	org 47242


	ld a,2
	call 5633	; main screen turn on

	ld hl,lines	; need to POKE the correct value in here (ORG+6,7)for all the required text
	ld b,(hl)	; loop the number of times that there are lines to be printed
	inc hl		; HL now points to the number of characters in the first line
ploop:	call printlines
	djnz ploop
	ret

printlines:
	push bc		; store the loop variable from LINES
	ld c,(hl)	; make sure the loop to print the text will print the correct number of characters - temp store in C
	inc hl
	ld a,22
	rst 16
	ld b,2
loop1:	ld a,(hl)
	rst 16
	inc hl
	djnz loop1	; PRINT AT position set, HL at the start of the text
	ld b,c		; recall the number of characters to print
loop2:	ld a,(hl)
	rst 16
	inc hl
	; a short "buzz" - requires HL and DE but still need to store BC because it'll be wrecked by the CALL
	push bc
	ld b,80
loop3:	ld a,16
	out (254),a
	xor a
	out (254),a
	djnz loop3
	; need a delay loop - store value of B beforehand
	ld bc,3072	; a nice, round $0C00 in hex
loop4:	dec bc
	ld a,b
	or c
	jr nz,loop4
	pop bc		; NOW we retrieve both B and C for this subroutine
	djnz loop2
	pop bc		; retrieve the loop variable from outside the subroutine
	ret

; data starts at ORG+58

lines:
	; ===== START OF GAME =====
	; Use only lines 9-21 - central line = 15

	; This section: 124 bytes
	defb 4
	defb 27,14,2
	defm "It started as a ludicrously"
	defb 24,15,4
	defm "over-polished ZX81 game,"
	defb 31,16,0
	defm "conceived in the most ludicrous"
	defb 29,17,1
	defm "year of 2020, for the CSSCGC."
	; This section: 91 bytes
	defb 3
	defb 25,14,3
	defm "It has been ported to the"
	defb 26,15,3
	defm "16K Spectrum, QL and three"
	defb 30,16,1
	defm "Commodore computers... so far."
	; This section: 103 bytes
	defb 4
	defb 28,14,2
	defm "Now the official sequel will"
	defb 22,15,5
	defm "push the boundaries of"
	defb 30,16,1
	defm "ludicrousness to their logical"
	defb 10,17,11
	defm "extreme..."
	; This section: 80 bytes
	defb 3
	defb 27,14,2
	defm "...while giving a very real"
	defb 30,15,1
	defm "warning that you would be wise"
	defb 13,16,10
	defm "to listen to."
	; This section: 212 bytes
	defb 7
	defb 32,11,0
	defm "Written by Jim Waterman, 2020-22"
	defb 29,13,1
	defm "...with extra bits and pieces"
	defb 32,14,0
	defm "pilfered from old Spectrum games"
	defb 29,15,2
	defm "from around 1983, when all we"
	defb 26,16,3
	defm "had to worry about was the"
	defb 23,17,5
	defm "Soviet Union dropping a"
	defb 19,18,7
	defm "nuclear bomb on us."
	; This section: 60 bytes
	defb 2
	defb 23,15,4
	defm "The more things change,"
	defb 30,16,1
	defm "the more they stay the same..."
	; This section: 34 bytes
	defb 1
	defb 30,15,1
	defm "IS THE TRUTH REALLY OUT THERE?"


	; ===== INTRODUCTORY TEXT, PART 1 (PRE-MAP) =====
	; Use only lines 9-21 - central line = 15

	; This section: 47 bytes
	defb 2		; total number of lines to print to the screen
	defb 20		; number of characters in text line
	defb 15,6	; PRINT AT 15,6
	defm "Ever get the feeling"
	defb 20,16,6
	defm "you've been cheated?"
	; This section: 221 bytes
	defb 7
	defb 30,12,1
	defm "I mean, seriously, the thought"
	defb 28,13,2
	defm "of an elite cabal called the"
	defb 27,14,2
	defm "Illuminati, controlling the"
	defb 29,15,2
	defm "world's leaders like puppets,"
	defb 26,16,3
	defm "who in turn controlled the"
	defb 32,17,0
	defm "people of their countries, doing"
	defb 27,18,3
	defm "the Illuminati's bidding..."
	; This section: 50 bytes
	defb 2
	defb 15,15,8
	defm "It's all just a"
	defb 28,16,2
	defm "conspiracy theory, isn't it?"
	; This section: 252 bytes
	defb 8
	defb 30,12,1
	defm "The fact that there were loons"
	defb 29,13,1
	defm "like Alex Jones ranting about"
	defb 30,14,1
	defm "them until he nearly exploded,"
	defb 30,15,1
	defm "and David Icke telling us they"
	defb 29,16,1
	defm "were secretly lizards wearing"
	defb 31,17,0
	defm "human skin suits didn't exactly"
	defb 30,18,1
	defm "fill us all with confidence in"
	defb 18,19,7
	defm "their credibility."
	; This section: 32 bytes
	defb 1
	defb 28,15,2
	defm "But we should have listened."
	; This section: 144 bytes
	defb 5
	defb 31,13,0
	defm "In 2020, during the Coronavirus"
	defb 23,14,4
	defm "pandemic, they revealed"
	defb 29,15,1
	defm "themselves, with their master"
	defb 25,16,3
	defm "plan to fix the world and"
	defb 20,17,6
	defb 34
	defm "Build Back Better"
	defb 34
	defm "."
	; This section: 40 bytes
	defb 2
	defb 18,15,7
	defb 34
	defm "The Great Reset"
	defb 34
	defm ","
	defb 15,16,8
	defm "they called it."
	; This section: 53 bytes
	defb 2
	defb 21,15,6
	defb 34
	defm "You will own nothing"
	defb 25,16,4
	defm "and be happy"
	defb 34
	defm ", they said."
	; This section: 68 bytes
	defb 2
	defb 30,15,1
	defm "And they specified 2030 as the"
	defb 31,16,1
	defm "target date for its completion."
	; This section: 159 bytes
	defb 5
	defb 29,13,1
	defb 34
	defm "They"
	defb 34
	defm " are the World Economic"
	defb 26,14,3
	defm "Forum. They meet in Davos,"
	defb 30,15,1
	defm "Switzerland, every year - and,"
	defb 31,16,0
	defm "in their own words, they decide"
	defb 27,17,2
	defm "the future, there and then."
	; This section: 150 bytes
	defb 5
	defb 28,13,2
	defm "The Great Reset would have a"
	defb 25,14,3
	defm "devastating effect on the"
	defb 32,15,0
	defm "country that the WEF singled out"
	defb 30,16,1
	defm "for removal from its status as"
	defb 19,17,7
	defm "a world superpower."
	; This section: 252 bytes
	defb 8
	defb 32,12,0
	defm "God-Emperor Trump was re-elected"
	defb 30,13,1
	defm "to the White House in 2024, to"
	defb 30,14,1
	defm "become the second President to"
	defb 32,15,0
	defm "serve non-consecutive terms. His"
	defb 29,16,1
	defm "Vice-President, Ron DeSantis,"
	defb 29,17,1
	defm "followed him in 2028. Between"
	defb 29,18,1
	defm "them, they managed to prevent"
	defb 16,19,8
	defm "The Great Reset."
	; This section: 258 bytes
	defb 8
	defb 29,12,1
	defm "Divisions between the ends of"
	defb 32,13,0
	defm "the political spectrum continued"
	defb 31,14,0
	defm "to widen - so much that the DNC"
	defb 30,15,1
	defm "chose Alexandria Ocasio-Cortez"
	defb 28,16,2
	defm "as their 2032 candidate, who"
	defb 32,17,0
	defm "nobody in their right mind would"
	defb 29,18,1
	defm "choose to open a tin of beans"
	defb 22,19,5
	defm "that was already open."
	; This section: 100 bytes
	defb 3
	defb 31,14,0
	defm "Even in this political climate,"
	defb 31,15,0
	defm "President DeSantis' second term"
	defb 28,16,2
	defm "was a foregone conclusion..."
	; This section: 17 bytes
	defb 1
	defb 13,15,9
	defm "...wasn't it?"
	; This section: 39 bytes
	defb 2
	defb 17,15,8
	defm "Ocasio-Cortez won"
	defb 15,16,9
	defm "by a landslide."
	; This section: 285 bytes
	defb 9
	defb 29,11,1
	defm "The WEF could barely disguise"
	defb 25,12,3
	defm "their delight, and openly"
	defb 28,13,1
	defm "admitted that this was their"
	defb 30,14,1
	defm "doing. President Ocasio-Cortez"
	defb 29,15,1
	defm "was their Chosen One, through"
	defb 30,16,1
	defm "whom they would impose an Even"
	defb 31,17,0
	defm "Greater Reset by 2050, and they"
	defb 31,18,0
	defm "had to ensure that she took the"
	defb 24,19,4
	defm "keys to the White House."
	; This section: 95 bytes
	defb 3
	defb 31,14,0
	defm "As eight years of Trumpist rule"
	defb 31,15,0
	defm "came crashing down, it took the"
	defb 23,16,4
	defm "entire country with it."
	; This section: 192 bytes
	defb 6
	defb 32,13,0
	defm "Because this time, the Trumpists"
	defb 31,14,1
	defm "had proof that the election was"
	defb 29,15,2
	defm "rigged. Nobody, not even CNN,"
	defb 30,16,1
	defm "could deny it... although that"
	defb 26,17,3
	defm "didn't stop the editors of"
	defb 25,18,4
	defm "RationalWiki from trying."


	; ===== INTRODUCTORY TEXT, PART 2 (POST-MAP) =====
	; Use only lines 9-21 - central line = 15

	; This section: 142 bytes
	defb 5
	defb 26,13,3
	defm "Between 2035 and 2040, the"
	defb 30,14,1
	defm "United States of America split"
	defb 27,15,3
	defm "into five successor states,"
	defb 28,16,2
	defm "all with their own strengths"
	defb 15,17,9
	defm "and weaknesses."
	; This section: 285 bytes
	defb 9
	defb 23,11,4
	defm "The Western Libertarian"
	defb 32,12,0
	defm "Federation, with its emphasis on"
	defb 31,13,0
	defm "gun ownership, civil liberties,"
	defb 26,14,3
	defm "and the sovereignty of the"
	defb 31,15,0
	defm "individual, was the ideological"
	defb 32,16,0
	defm "opposite of the WEF, and clashed"
	defb 30,17,1
	defm "even harder with them than the"
	defb 29,18,1
	defm "hyper-authoritarian Christian"
	defb 23,19,4
	defm "Confederate States did."
	; This section: 215 bytes
	defb 7
	defb 30,12,1
	defm "A further source of irritation"
	defb 25,13,3
	defm "was the similar acronyms,"
	defb 30,14,1
	defm "causing the WLF to be confused"
	defb 27,15,2
	defm "with the WEF by the kind of"
	defb 30,16,1
	defm "painfully uneducated NPCs that"
	defb 29,17,1
	defm "regularly took part in street"
	defb 22,18,5
	defm "surveys in big cities."
	; This section: 192 bytes
	defb 6
	defb 30,13,1
	defm "But this was a trifling matter"
	defb 27,14,2
	defm "compared to the WLF's major"
	defb 32,15,0
	defm "disadvantage: its only coastline"
	defb 30,16,1
	defm "was inconveniently situated in"
	defb 29,17,1
	defm "Alaska, with the remainder of"
	defb 25,18,3
	defm "its territory landlocked."
	; This section: 174 bytes
	defb 6
	defb 28,13,2
	defm "The entire Pacific coast was"
	defb 28,14,2
	defm "occupied by the Anti-Fascist"
	defb 31,15,1
	defm "Rainbow Commune, best described"
	defb 30,16,1
	defm "as Portland scaled up to three"
	defb 27,17,3
	defm "states with a population of"
	defb 11,18,11
	defm "50 million."
	; This section: 162 bytes
	defb 5
	defb 30,13,1
	defm "The AFRC became a Failed State"
	defb 30,14,1
	defm "within a month of independence"
	defb 29,15,2
	defm "and the WEF stepped in to act"
	defb 28,16,2
	defm "as their babysitter, the Big"
	defb 29,17,2
	defm "Daddy Government they craved."
	; This section: 153 bytes
	defb 5
	defb 27,13,3
	defm "The WLF came to the obvious"
	defb 31,14,1
	defm "conclusion: to gain easy access"
	defb 31,15,1
	defm "to the Pacific coast and ensure"
	defb 27,16,3
	defm "enduring world freedom, the"
	defb 21,17,6
	defm "WEF must be defeated."


	; ===== INSTRUCTIONS =====
	; Use only lines 9-21 - central line = 15

	; This section: 235 bytes
	defb 7
	defb 32,12,0
	defm "It is December 2042. You are the"
	defb 32,13,0
	defm "Western Libertarian Federation's"
	defb 31,14,1
	defm "most skilled saboteur, and your"
	defb 30,15,1
	defm "job is to infiltrate the World"
	defb 31,16,1
	defm "Economic Forum's annual meeting"
	defb 28,17,2
	defm "and deliver them a Christmas"
	defb 29,18,2
	defm "present they'll never forget."
	; This section: 73 bytes
	defb 3
	defb 21,14,6
	defm "The major hurdle that"
	defb 23,15,5
	defm "blocks your entrance is"
	defb 19,16,7
	defm "the Davos Deadlock."
	; This section: 280 bytes
	defb 9
	defb 30,11,1
	defm "This is an upgraded version of"
	defb 27,12,3
	defm "the Illuminati's Top-Secret"
	defb 31,13,1
	defm "Pyramid. As with that painfully"
	defb 31,14,1
	defm "insecure device, you must input"
	defb 27,15,3
	defm "three hex bytes. These will"
	defb 32,16,0
	defm "propagate up the pyramid in line"
	defb 31,17,1
	defm "with the original code to leave"
	defb 26,18,3
	defm "a single hex byte - an odd"
	defb 17,19,8
	defm "number above 80h."
	; This section: 190 bytes
	defb 6
	defb 31,13,0
	defm "This will generate a key, which"
	defb 30,14,1
	defm "alters how the bytes propagate"
	defb 29,15,1
	defm "up the pyramid - and it is on"
	defb 30,16,1
	defm "this second pass that you will"
	defb 29,17,1
	defm "need to match the target byte"
	defb 22,18,5
	defm "shown in the Evil Eye."
	; This section: 116 bytes
	defb 4
	defb 28,14,2
	defm "This time, all 256 bytes are"
	defb 25,15,4
	defm "possible, but some of the"
	defb 31,16,1
	defm "targets are considerably harder"
	defb 19,17,7
	defm "to hit than others."
	; This section: 149 bytes
	defb 5
	defb 32,13,0
	defm "Your hacking skill is sufficient"
	defb 29,14,2
	defm "to allow 40 attempts to break"
	defb 31,15,1
	defm "the Davos Deadlock, and release"
	defb 20,16,6
	defm "the iron grip of the"
	defb 21,17,6
	defm "technocratic tyrants."
	; This section: 45 bytes
	defb 2
	defb 24,15,4
	defm "Believe me, you dare not"
	defb 14,16,9
	defm "lose this one."
	; This section: 90 bytes
	defb 3
	defb 29,14,2
	defm "Not just the fate of the WLF,"
	defb 30,15,1
	defm "but that of the entire Western"
	defb 21,16,6
	defm "world depends on you."


	; ===== NPC ENDING (ONLY LOSS POSSIBLE) =====
	; Use only lines 9-21 - central line = 15
	; ALSO, the NPC face will take up the leftmost 14 columns,
	; so to leave one square of space, use only
	; the rightmost 17 columns.
	
	; This section: 25 bytes
	defb 2
	defb 9,15,19
	defm "You utter"
	defb 9,16,19
	defm "brainlet."

	; This section: 39 bytes
	defb 2
	defb 16,15,16
	defm "You selected the"
	defb 16,16,16
	defm "NPC spice level."

	; This section: 26 bytes
	defb 2
	defb 11,15,18
	defm "Why did you"
	defb 8,16,20
	defm "do that?"

	; This section: 88 bytes
	defb 5
	defb 10,13,18
	defm "Didn't you"
	defb 15,14,16
	defm "realise that an"
	defb 15,15,16
	defm "NPC had no hope"
	defb 15,16,16
	defm "of breaking the"
	defb 17,17,15
	defm "Davos Deadlock..."

	; This section: 40 bytes
	defb 2
	defb 17,15,15
	defm "...nor any desire"
	defb 16,16,16
	defm "to do so either?"

	; This section: 87 bytes
	defb 5
	defb 14,13,17
	defm "If you want to"
	defb 12,14,18
	defm "see a better"
	defb 16,15,16
	defm "ending, crank up"
	defb 15,16,16
	defm "the spice level"
	defb 14,17,17
	defm "and try again."

	
	; ===== MILQUETOAST LOSS =====
	; Use only lines 9-21 - central line = 15

	; Lines common to both loses
	
	; This section: 23 bytes
	defb 1
	defb 19,15,6
	defm "What have you done?"
	; This section: 35 bytes
	defb 1
	defb 31,15,1
	defm "No, really, what have you done?"
	; This section: 49 bytes
	defb 2
	defb 14,15,9
	defm "You've failed."
	defb 28,16,2
	defm "The Davos Deadlock beat you."

	; Six lines for MT loss only -
	; Pepe loss has five alternative lines

	; This section: 114 bytes
	defb 4
	defb 28,14,2
	defm "Klaus Schwab and all his WEF"
	defb 26,15,3
	defm "goons were alerted to your"
	defb 27,16,2
	defm "presence, and you have been"
	defb 20,17,6
	defm "suitably dealt with."
	; This section: 188 bytes
	defb 6
	defb 32,13,0
	defm "For now, the Western Libertarian"
	defb 27,14,3
	defm "Federation will be the last"
	defb 31,15,1
	defm "remaining bastion of liberty in"
	defb 31,16,1
	defm "the Western world. But it won't"
	defb 27,17,3
	defm "be long before that is also"
	defb 21,18,6
	defm "extinguished forever."
	; This section: 190 bytes
	defb 6
	defb 30,13,1
	defm "Property rights, self-defence,"
	defb 26,14,3
	defm "individualism, all will be"
	defb 27,15,2
	defm "slaughtered on the altar of"
	defb 29,16,1
	defb 34
	defm "progress"
	defb 34
	defm ", ushering in a new"
	defb 30,17,1
	defm "age of collectivism, permanent"
	defb 29,18,1
	defm "monitoring and social credit."
	; This section: 149 bytes
	defb 5
	defb 25,13,3
	defm "As you start your eternal"
	defb 26,14,3
	defm "incarceration, it is of no"
	defb 29,15,1
	defm "consolation that you tried to"
	defb 25,16,3
	defm "keep the torch of liberty"
	defb 28,17,2
	defm "burning, because you failed."
	; This section: 49 bytes
	defb 2
	defb 25,15,4
	defm "One day, this prison will"
	defb 17,16,8
	defm "become your tomb."
	; This section: 74 bytes
	defb 3
	defb 28,14,2
	defm "Those who remain outside its"
	defb 23,15,5
	defm "walls will own nothing,"
	defb 13,16,10
	defm "and be happy."

	; Start of another common section between losses

	; This section: 178 bytes
	defb 6
	defb 28,13,2
	defm "They will smile their forced"
	defb 30,14,1
	defm "Stepford Smiles as their homes"
	defb 23,15,5
	defm "are bulldozed and their"
	defb 27,16,3
	defm "possessions are seized, and"
	defb 28,17,2
	defm "they are introduced to their"
	defb 23,18,5
	defm "new lives in Nano-Pods."
	; This section: 194 bytes
	defb 6
	defb 30,13,1
	defm "All they'll get is a bed each,"
	defb 32,14,0
	defm "in a space that makes a Japanese"
	defb 25,15,3
	defm "capsule hotel look like a"
	defb 32,16,0
	defm "palace. The mere idea of privacy"
	defb 27,17,2
	defm "is laughable. Everything is"
	defb 29,18,1
	defm "communal, even their clothes."
	; This section: 69 bytes
	defb 2
	defb 32,15,0
	defm "And don't ask what's on the menu"
	defb 30,16,1
	defm "unless you're fond of insects."

	; PEPE LOSS HAS AN EXTRA line here
	; Twelve hundred lives ended. And for what?

	; This section: 118 bytes
	defb 4
	defb 26,14,3
	defm "One billion lives all over"
	defb 31,15,0
	defm "the West, turned into a hellish"
	defb 26,16,3
	defm "nightmare from which it is"
	defb 22,17,5
	defm "impossible to wake up."
	; This section: 65 bytes
	defb 2
	defb 27,15,3
	defm "One billion people who have"
	defb 31,16,1
	defm "no mouth, and they must scream."
	; This section: 17 bytes
	defb 1
	defb 13,15,10
	defm "You did that."
	; This section: 20 bytes
	defb 1
	defb 16,15,8
	defm "Merry Christmas."


	; ===== PEPE LOSS =====
	; Use only lines 9-21 - central line = 15
	
	; Use first three lines of Milquetoast, then this...
	
	; This section: 120 bytes
	defb 4
	defb 24,13,4
	defm "Klaus Schwab and all his"
	defb 27,14,2
	defm "WEF goons were alerted, and"
	defb 30,15,1
	defm "scarpered to safety. Who knows"
	defb 26,16,3
	defm "where they will resurface?"
	; This section: 155 bytes
	defb 5
	defb 29,13,1
	defm "Instead, you now have to deal"
	defb 30,14,1
	defm "with the inescapable fact that"
	defb 32,15,0
	defm "you've detonated a gigantic bomb"
	defb 30,16,1
	defm "in what is usually an ordinary"
	defb 18,17,6
	defm "Alpine ski resort."
	; This section: 257 bytes
	defb 8
	defb 30,12,1
	defm "You have the blood of around a"
	defb 32,13,0
	defm "thousand locals, and a couple of"
	defb 31,14,1
	defm "hundred tourists on your hands."
	defb 30,15,1
	defm "Innocent, all of them. Some of"
	defb 31,16,0
	defm "them only came to get away from"
	defb 31,17,0
	defm "their otherwise miserable lives"
	defb 29,18,1
	defm "for a week. How are you going"
	defb 18,19,6
	defm "to live with that?"
	; This section: 211 bytes
	defb 7
	defb 32,12,0
	defm "Well done on ending those lives."
	defb 27,13,2
	defm "No, really, well done. That"
	defb 28,14,2
	defm "wasn't even sarcasm. Because"
	defb 29,15,1
	defm "they are the lucky ones. They"
	defb 30,16,1
	defm "won't have to live through the"
	defb 24,17,4
	defm "horror that the next few"
	defb 19,18,6
	defm "decades will bring."
	; This section: 60 bytes
	defb 2
	defb 27,15,2
	defm "Those who remain alive will"
	defb 26,16,3
	defm "own nothing, and be happy."

	; Return to Milquetoast for three lines,
	; then add this extra line:
	
	; This section: 47 bytes
	defb 2
	defb 27,15,3
	defm "Twelve hundred lives ended."
	defb 13,16,10
	defm "And for what?"

	; Remainder is as for Milquetoast loss.


	; ===== MILQUETOAST WIN =====
	
	; This section: 61 bytes
	defb 2
	defb 27,15,2
	defm "Well, you did it. You broke"
	defb 27,16,2
	defm "through the Davos Deadlock."
	; This section: 111 bytes
	defb 4
	defb 32,14,0
	defm "The leering face of Klaus Schwab"
	defb 23,15,4
	defm "glares down at you from"
	defb 29,16,1
	defm "Big Brother-esque telescreens"
	defb 14,17,9
	defm "on every wall."
	; This section: 122 bytes
	defb 4
	defb 25,14,4
	defm "Despite this, you swagger"
	defb 29,15,2
	defm "through the WEF headquarters,"
	defb 28,16,2
	defm "undetected. Your disguise as"
	defb 27,17,3
	defm "Justin Trudeau was perfect."
	; This section: 217 bytes
	defb 7
	defb 31,12,1
	defm "You stop briefly to look in the"
	defb 29,13,2
	defm "Grand Hall of Social Justice,"
	defb 26,14,3
	defm "where Uncle Klaus' wizened"
	defb 32,15,0
	defm "104-year-old body is wired up to"
	defb 30,16,1
	defm "more life support systems than"
	defb 26,17,3
	defm "there are hospitals in the"
	defb 21,18,6
	defm "whole of Switzerland."
	; This section: 45 bytes
	defb 2
	defb 20,15,6
	defm "It's as if he's more"
	defb 18,16,7
	defm "Davros than Davos."
	; This section: 172 bytes
	defb 6
	defb 25,13,3
	defm "Once you find the central"
	defb 28,14,2
	defm "computer room, it takes mere"
	defb 31,15,0
	defm "minutes to unleash the Ragnarok"
	defb 29,16,1
	defm "virus. By the time anyone has"
	defb 26,17,3
	defm "twigged what you're doing,"
	defb 14,18,9
	defm "it's too late."
	; This section: 131 bytes
	defb 4
	defb 30,14,1
	defm "Ten billion terabytes of data,"
	defb 32,15,0
	defm "that would allow the WEF to keep"
	defb 31,16,0
	defm "the world's citizens in digital"
	defb 25,17,3
	defm "chains, goes up in smoke."
	; This section: 74 bytes
	defb 3
	defb 26,14,3
	defm "Google will probably never"
	defb 25,15,4
	defm "recover, but it's a small"
	defb 13,16,10
	defm "price to pay."
	; This section: 178 bytes
	defb 6
	defb 25,13,3
	defm "The sole casualty of your"
	defb 30,14,1
	defm "operation is Klaus Schwab. His"
	defb 29,15,1
	defm "life support systems were all"
	defb 27,16,2
	defm "deactivated. But then, he's"
	defb 30,17,1
	defm "not really human at this point"
	defb 18,18,7
	defm "and doesn't count."
	; This section: 34 bytes
	defb 1
	defb 30,15,1
	defm "Some would say he never was..."
	; This section: 214 bytes
	defb 7
	defb 29,12,1
	defm "The Western world will now be"
	defb 27,13,2
	defm "free. You have ensured that"
	defb 22,14,5
	defm "property rights, civil"
	defb 32,15,0
	defm "liberties, and the rights of the"
	defb 30,16,1
	defm "individual over the collective"
	defb 30,17,1
	defm "will be preserved, rather than"
	defb 22,18,5
	defm "ruthlessly eliminated."
	; This section: 161 bytes
	defb 5
	defb 27,13,3
	defm "Maybe the more intransigent"
	defb 31,14,1
	defm "countries will learn a thing or"
	defb 32,15,0
	defm "two from the Western Libertarian"
	defb 28,16,2
	defm "Federation about not trading"
	defb 27,17,3
	defm "liberty to purchase safety."
	; This section: 207 bytes
	defb 7
	defb 29,12,2
	defm "It'll be the greatest festive"
	defb 31,13,1
	defm "season ever for everyone in the"
	defb 31,14,1
	defm "West... except the Anti-Fascist"
	defb 27,15,3
	defm "Rainbow Commune, which will"
	defb 30,16,1
	defm "collapse like a house of cards"
	defb 22,17,5
	defm "in an earthquake, in a"
	defb 15,18,9
	defm "matter of days."
	; This section: 77 bytes
	defb 3
	defb 27,14,2
	defm "Massive clean-up job on the"
	defb 20,15,6
	defm "Pacific coast aside,"
	defb 20,16,6
	defm "the future's bright."
	; This section: 20 bytes
	defb 1
	defb 16,15,8
	defm "Merry Christmas."
		
	
	; ===== PEPE WIN =====
	
	; first line is shared with Milquetoast win
	
	; This section: 181 bytes
	defb 6
	defb 25,13,3
	defm "The WEF headquarters were"
	defb 28,14,2
	defm "unbreachably sealed for long"
	defb 30,15,1
	defm "enough to allow the evacuation"
	defb 28,16,2
	defm "of Davos. The people fled in"
	defb 32,17,0
	defm "terror, and could hear the blast"
	defb 19,18,6
	defm "from 20 miles away."
	; This section: 64 bytes
	defb 2
	defb 31,15,0
	defm "Klaus Schwab and all his little"
	defb 26,16,3
	defm "wizards were not so lucky."
	; This section: 32 bytes
	defb 1
	defb 28,15,2
	defm "Of course, neither were you."
	; This section: 93 bytes
	defb 3
	defb 32,14,0
	defm "With your body ripped to pieces,"
	defb 29,15,1
	defm "your earthly soul descends to"
	defb 22,16,5
	defm "where Hell used to be."
	; This section: 220 bytes
	defb 7
	defb 25,12,3
	defm "Of course, it isn't there"
	defb 27,13,2
	defm "any more, not since Doomguy"
	defb 25,14,3
	defm "smashed it to smithereens"
	defb 31,15,0
	defm "back in 1994. He wondered where"
	defb 32,16,0
	defm "bad folks will go when they die,"
	defb 32,17,0
	defm "now. The answer is to an eternal"
	defb 26,18,3
	defm "blackness; total oblivion."
	; This section: 159 bytes
	defb 5
	defb 27,13,2
	defm "Amongst the still-living on"
	defb 28,14,2
	defm "Earth, news reports from the"
	defb 30,15,1
	defm "mainstream media denounce your"
	defb 32,16,0
	defm "sacrifice as the greatest act of"
	defb 26,17,3
	defm "evil in over four decades."
	; This section: 82 bytes
	defb 3
	defb 21,14,5
	defm "History is written by"
	defb 26,15,3
	defm "the winners, and you're no"
	defb 25,16,4
	defm "longer there to write it."
	; This section: 130 bytes
	defb 4
	defb 26,13,3
	defm "If only they knew what the"
	defb 30,14,1
	defm "future would have held had you"
	defb 32,15,0
	defm "failed to deliver the fatal blow"
	defb 29,16,2
	defm "to the true forces of evil..."
	; This section: 185 bytes
	defb 6
	defb 22,13,5
	defm "It isn't going to be a"
	defb 30,14,1
	defm "Merry Christmas for the people"
	defb 31,15,0
	defm "of Davos. They've got a town to"
	defb 31,16,0
	defm "rebuild. It isn't going to be a"
	defb 32,17,0
	defm "Merry Christmas for you, either,"
	defb 20,18,6
	defm "because you're dead."
	; This section: 88 bytes
	defb 3
	defb 31,14,0
	defm "But you have ensured there will"
	defb 30,15,1
	defm "be many more Merry Christmases"
	defb 17,16,8
	defm "in years to come."
	; This section: 183 bytes
	defb 6
	defb 26,13,3
	defm "You have also ensured that"
	defb 22,14,5
	defm "property rights, civil"
	defb 30,15,1
	defm "liberties, and the sovereignty"
	defb 26,16,3
	defm "of the individual over the"
	defb 29,17,2
	defm "collective will be preserved,"
	defb 31,18,1
	defm "rather than ruthlessly crushed."
	; This section: 246 bytes
	defb 8
	defb 30,12,1
	defm "Maybe one day, when the people"
	defb 28,13,2
	defm "of the Western world realise"
	defb 31,14,1
	defm "what they could have lost, your"
	defb 25,15,4
	defm "deeds will be reassessed."
	defb 29,16,2
	defm "For now, you have planted the"
	defb 31,17,1
	defm "seed, that will eventually grow"
	defb 28,18,2
	defm "into the tree in whose shade"
	defb 19,19,6
	defm "you will never sit."
	; This section: 125 bytes
	defb 4
	defb 32,14,0
	defm "Fittingly, it's a pine tree that"
	defb 30,15,1
	defm "would look suitably festive if"
	defb 30,16,1
	defm "festooned with tinsel, baubles"
	defb 20,17,6
	defm "and flashing lights."

	; last line is shared with Milquetoast win


	; ===== ORIGINAL ILLUMINATI INSTRUCTIONS =====
	; title occupies lines 0-8, use only lines 10-21 - central lines = 15-16

	; This section: 124 bytes
	defb 4
	defb 28,14,2
	defm "The Illuminati are trying to"
	defb 30,15,1
	defm "take control of the world, and"
	defb 28,16,2
	defm "it is your job to stop them."
	defb 25,18,4
	defm "(Well, imagine my shock!)"
	; This section: 234 bytes
	defb 7
	defb 32,13,0
	defm "You will be asked to input three"
	defb 31,14,1
	defm "hex bytes, which will be placed"
	defb 29,15,2
	defm "in the cells at the bottom of"
	defb 31,16,1
	defm "the Illuminati's pyramid. These"
	defb 29,17,2
	defm "will propagate up the pyramid"
	defb 29,18,2
	defm "in line with the Illuminati's"
	defb 31,19,1
	defm "top-secret calculation formula."
	; This section: 234 bytes
	defb 8
	defb 29,12,1
	defm "If the hex byte at the top of"
	defb 30,13,1
	defm "the pyramid matches the one in"
	defb 29,14,1
	defm "the Evil Eye, a big bomb will"
	defb 31,15,0
	defm "be detonated (or something like"
	defb 32,16,0
	defm "that, anyway) and the Illuminati"
	defb 18,17,7
	defm "will be destroyed."
	defb 30,19,1
	defm "(I did say this was ludicrous,"
	defb 10,20,11
	defm "didn't I?)"
	; This section: 182 bytes
	defb 6
	defb 26,13,3
	defm "There will appear to be no"
	defb 25,14,4
	defm "logic to the Illuminati's"
	defb 28,15,2
	defm "calculations - but there is,"
	defb 30,16,1
	defm "and I should know, I wrote it."
	defb 25,17,4
	defm "To find out how it works,"
	defb 29,18,2
	defm "disassemble the machine code."
	; This section: 192 bytes
	defb 6
	defb 29,13,2
	defm "There are 64 possible results"
	defb 30,14,1
	defm "from the calculations, and you"
	defb 30,15,1
	defm "get 16 attempts, so you have a"
	defb 26,16,3
	defm "25% chance of stopping the"
	defb 27,17,3
	defm "Illuminati... in this game,"
	defb 31,18,1
	defm "at least. Less so in real life."
	; This section: 102 bytes
	defb 3
	defb 29,15,1
	defm "IMPORTANT NOTE: No frogs were"
	defb 31,16,0
	defm "turned gay by putting chemicals"
	defb 32,17,0
	defm "in the water during programming."


	; ===== ORIGINAL ILLUMINATI LOSS =====

	; This section: 49 bytes
	defb 2
	defb 21,15,6
	defm "You fail it, and that"
	defb 21,16,6
	defm "makes me a sad panda."
	; This section: 56 bytes
	defb 2
	defb 26,15,3
	defm "The Illuminati ran rampant"
	defb 23,16,5
	defm "throughout the world..."
	; This section: 46 bytes
	defb 2
	defb 17,15,8
	defm "...and you barely"
	defb 22,16,5
	defm "notice any difference."


	; ===== ORIGINAL ILLUMINATI WIN =====

	; This section: 32 bytes
	defb 1
	defb 28,16,2
	defm "Congraturation, you sucsess!"
	; This section: 33 bytes
	defb 1
	defb 29,16,2
	defm "The Illuminati are destroyed."
	; This section: 30 bytes
	defb 1
	defb 26,16,3
	defm "David Icke would be proud."
	; This section: 186 bytes
	defb 6
	defb 28,13,2
	defm "Unfortunately, you have also"
	defb 29,14,2
	defm "destroyed the world's tinfoil"
	defb 30,15,1
	defm "industry, because it relied on"
	defb 28,16,2
	defm "conspiracy loons making hats"
	defb 29,17,2
	defm "out of it, and there are more"
	defb 23,18,5
	defm "of them than you think!"



